<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\Interest;
use Import\ApiBundle\Entity\PaymentMin;

/**
 * PaymentMinRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PaymentMinRepository extends EntityRepository
{
    /**
     * add new PaymentMin
     *
     * @param $data
     * @param bool $flush
     * @return PaymentMin
     */
    public function add($data, $flush = false)
    {
        $PaymentMin = new PaymentMin();

        $PaymentMin->setValue($data['Value']);
        $PaymentMin->setDataFrom($data['DataFrom']);
        if(isset($data['DataTo']))
        {
            $PaymentMin->setDataTo($data['DataTo']);
        }

        $this->getEntityManager()->persist($PaymentMin);
        if($flush)
        {
            $this->getEntityManager()->flush();
        }

        return $PaymentMin;
    }

    /**
     * get last PaymentMin
     *
     * @return null|PaymentMin
     */
    public function getLastMinPayment()
    {
        $QueryBuilder = $this->createQueryBuilder('p');
        $QueryBuilder
            ->select('p')
            ->orderBy('p.dataFrom','DESC')
            ->setMaxResults(1)
        ;

        return $QueryBuilder->getQuery()->getOneOrNullResult();
    }
}
